// MFCClientDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MFCClient.h"
#include "MFCClientDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMFCClientDlg dialog

CMFCClientDlg::CMFCClientDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMFCClientDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMFCClientDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMFCClientDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMFCClientDlg)
	DDX_Control(pDX, IDC_LIST1, m_ListBox);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMFCClientDlg, CDialog)
	//{{AFX_MSG_MAP(CMFCClientDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_LBN_DBLCLK(IDC_LIST1, OnDblclkList1)
	ON_BN_CLICKED(IDC_ABOUT, OnAbout)
	ON_BN_CLICKED(IDC_CLEARLIST, OnClearList)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMFCClientDlg message handlers
/////////////////////////////////////////////////////////////////////////////
BOOL CMFCClientDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}


//  If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.
void CMFCClientDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}


/////////////////////////////////////////////////////////////////////////////
// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
/////////////////////////////////////////////////////////////////////////////
HCURSOR CMFCClientDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::OnAbout() 
{
    try
    {	// Usage of the type library instead of the header is preferred
	    SIMPROFILELib::IProfilePtr p(__uuidof(SIMPROFILELib::Profile));
	    // HRESULT hr = p.CreateInstance(__uuidof(SIMPROFILELib::Profile))
	    p->AboutBox();
    }
    catch( const _com_error& Err )
    {
	    TCHAR buffer[255] = {0};
	    wsprintf(buffer, _T("Error: 0x%x "), Err.Error() );
	    MessageBox(buffer, _T("Error") );
    }
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::OnButton1() 
{
    GetSchedEvents();
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::OnButton2() 
{
    GetOrganizations();
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::OnButton3() 
{
	GetProdSyl();
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::OnClearList() 
{
    m_ListBox.ResetContent();
    m_iQuery = 0;
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::OnDblclkList1() 
{
    switch( m_iQuery )
    {
    case GETPRODSYL:
        if( SetParameter(2) )
            GetDeviceEvents();
        break;

    case GETSTUDENTS:
        if( SetParameter(2) )
            GetStudentOptions();
        break;

    case GETORGANIZATIONS:
        if( SetParameter(0) )
        GetStudents();
        break;

    default:
        break;
    }

}


/////////////////////////////////////////////////////////////////////////////
BOOL CMFCClientDlg::SetParameter( int iTokPos ) // Zero based token position
{
    int iPos = m_ListBox.GetCurSel();
    CString strTmp;
    m_ListBox.GetText( iPos, strTmp );
    if( strTmp[0] != '*' && strTmp.GetLength() > 0 )
    {
        char seps[] = "^";
        char* pToken;
        char* pString;
        pString = strTmp.GetBuffer(30);

        pToken = strtok( pString, seps );
        for( int i=0; i<iTokPos; i++ )
        {
            pToken = strtok( NULL, seps );
        }

        CString str;
        str = pToken;
        str.TrimLeft();
        str.TrimRight();
        m_bstrParameter = str;

        return TRUE;
    }
    return FALSE;
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::GetSchedEvents()
{
    // Set the Query
    m_iQuery = 0;

    // Set cursor to be astheticly pleasing
    HCURSOR hWaitCursor = LoadCursor( NULL, IDC_WAIT );
    HCURSOR hPrevCursor = SetCursor( hWaitCursor );

    try
    {
        SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
	    
	    // The following is not necessary, but can make debugging easier
	    //HRESULT hr = p.CreateInstance( __uuidof(SIMPROFILELib::Profile) );
	    
        // Use the SimProfile COM object
        _RecordsetPtr ADORecSetPtr;
        HRESULT hr = p->GetSchedEvents( (SIMPROFILELib::_Recordset**)&ADORecSetPtr );

        if( SUCCEEDED(hr) )
        {

            short bEOF = NULL;

            if (!ADORecSetPtr->adoEOF)
            {
                ADORecSetPtr->MoveFirst();
            }

            //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_RESETCONTENT, NULL, NULL );
            m_ListBox.ResetContent();
            m_ListBox.AddString( "INSTRUCTOR ^ STUDENT ^ EVENT ^ SORTIEFILE ^ START ^ DURATION ^ END ^ DEVICE ^ DOMAIN ^ LOGON" );

            while( !bEOF )
            {
                // Get fields from recordset
                HRESULT hr;
                _variant_t vVar0;
                _variant_t vVar1;
                _variant_t vVar2;
                _variant_t vVar3;
                _variant_t vVar4;
                _variant_t vVar5;
                _variant_t vVar6;
                _variant_t vVar7;
                _variant_t vVar8;
                _variant_t vVar9;
                CString strBuffer;

                // Named method (this works if using sql server and you know the field name)
                //_variant_t vField;
                //vField.vt = VT_BSTR;
                //vField.bstrVal = SysAllocString(L"NAME_NM");
                //hr = ADORecSetPtr->get_Collect( vField, &vVar1 );

                // Positional method
                hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar0 );
                if( vVar0.vt != VT_NULL )
                {
                    if( vVar0.vt == VT_BSTR )
                    {
                        strBuffer = vVar0.bstrVal;
                        strBuffer += "^";
                    }
                }
            
                hr = ADORecSetPtr->get_Collect( variant_t((long)1), &vVar1 );
                if( vVar1.vt != VT_NULL )
                {
                    if( vVar1.vt == VT_BSTR )
                    {
                        strBuffer += vVar1.bstrVal;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)2), &vVar2 );
                if( vVar2.vt != VT_NULL )
                {
                    if( vVar2.vt == VT_BSTR )
                    {
                        strBuffer += vVar2.bstrVal;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)3), &vVar3 );
                if( vVar3.vt != VT_NULL )
                {
                    if( vVar3.vt == VT_BSTR )
                    {
                        strBuffer += vVar3.bstrVal;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)4), &vVar4 );
                if( vVar4.vt != VT_NULL )
                {
                    if( vVar4.vt != VT_EMPTY )
                    {
                        COleDateTime dt = vVar4.date;
                        CString strTmp = dt.Format("%y-%m-%d %H:%M");
                        strBuffer += strTmp;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)5), &vVar5 );
                if( vVar5.vt != VT_NULL )
                {
                    if( vVar5.vt != VT_EMPTY )
                    {
                        char cTmp[10];
                        float fTmp = ((float)vVar5.intVal)/10000;
                        _gcvt( fTmp, 4, cTmp );
                        strBuffer += cTmp;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)6), &vVar6 );
                if( vVar6.vt != VT_NULL )
                {
                    if( vVar6.vt != VT_EMPTY )
                    {
                        COleDateTime dt = vVar6.date;
                        CString strTmp = dt.Format("%y-%m-%d %H:%M");
                        strBuffer += strTmp;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)7), &vVar7 );
                if( vVar7.vt != VT_NULL )
                {
                    if( vVar7.vt == VT_BSTR )
                    {
                        strBuffer += vVar7.bstrVal;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)8), &vVar8 );
                if( vVar8.vt != VT_NULL )
                {
                    if( vVar8.vt == VT_BSTR )
                    {
                        strBuffer = vVar8.bstrVal;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)9), &vVar9 );
                if( vVar9.vt != VT_NULL )
                {
                    if( vVar9.vt == VT_BSTR )
                    {
                        strBuffer = vVar9.bstrVal;
                    }
                }

                //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_ADDSTRING, NULL, (LPARAM)((char*)bstrBuffer) );
                m_ListBox.AddString( strBuffer );

                // Move pointer to next
                ADORecSetPtr->MoveNext();
                bEOF = ADORecSetPtr->adoEOF;
            }
            m_ListBox.SetCurSel(0); // Highlight the col headers
        }
    }
	catch( _com_error &e )
    {
		DumpError(e);
	}
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::GetOrganizations()
{
    // Set the Query
    m_iQuery = GETORGANIZATIONS;

    // Set cursor to be astheticly pleasing
    HCURSOR hWaitCursor = LoadCursor( NULL, IDC_WAIT );
    HCURSOR hPrevCursor = SetCursor( hWaitCursor );

    try
    {
        SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
	    
	    // The following is not necessary, but can make debugging easier
	    //HRESULT hr = p.CreateInstance( __uuidof(SIMPROFILELib::Profile) );
	    
        // Use the SimProfile COM object
        _RecordsetPtr ADORecSetPtr;
        HRESULT hr = p->GetOrganizations( (SIMPROFILELib::_Recordset**)&ADORecSetPtr );

        if( SUCCEEDED(hr) )
        {
            short bEOF = NULL;

            if (!ADORecSetPtr->adoEOF)
            {
                ADORecSetPtr->MoveFirst();
            }

            //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_RESETCONTENT, NULL, NULL );
            m_ListBox.ResetContent();
            m_ListBox.AddString( "TRAININGORG" );

            while( !bEOF )
            {
                // Get fields from recordset
                HRESULT hr;
                _variant_t vVar0;
                CString strBuffer;

                // Named method (this works if using sql server and you know the field name)
                //_variant_t vField;
                //vField.vt = VT_BSTR;
                //vField.bstrVal = SysAllocString(L"NAME_NM");
                //hr = ADORecSetPtr->get_Collect( vField, &vVar1 );

                // Positional method
                hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar0 );

                if( vVar0.vt != VT_NULL )
                {
                    if( vVar0.vt == VT_BSTR )
                    {
                        strBuffer = vVar0.bstrVal;
                    }
                }
            
                //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_ADDSTRING, NULL, (LPARAM)((char*)bstrBuffer) );
                m_ListBox.AddString( strBuffer );

                // Move pointer to next
                ADORecSetPtr->MoveNext();
                bEOF = ADORecSetPtr->adoEOF;
            }
            m_ListBox.SetCurSel(0); // Highlight the col headers
        }
    }
	catch( _com_error &e )
    {
		DumpError(e);
	}
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::GetStudents()
{
    // Set the Query
    m_iQuery = GETSTUDENTS;

    // Set cursor to be astheticly pleasing
    HCURSOR hWaitCursor = LoadCursor( NULL, IDC_WAIT );
    HCURSOR hPrevCursor = SetCursor( hWaitCursor );

    try
    {
        SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
	    
	    // The following is not necessary, but can make debugging easier
	    //HRESULT hr = p.CreateInstance( __uuidof(SIMPROFILELib::Profile) );
	    
        // Use the SimProfile COM object
        _RecordsetPtr ADORecSetPtr;
        HRESULT hr = p->GetStudents( (SIMPROFILELib::_Recordset**)&ADORecSetPtr, m_bstrParameter );

        if( SUCCEEDED(hr) )
        {
            short bEOF = NULL;

            if (!ADORecSetPtr->adoEOF)
            {
                ADORecSetPtr->MoveFirst();
            }

            //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_RESETCONTENT, NULL, NULL );
            m_ListBox.ResetContent();
            m_ListBox.AddString( "STUDENT ^ SSN ^ RESID ^ SYLID ^ ACTTIME ^ NOTACTTIME ^ DOMAIN ^ LOGON" );
        
            while( !bEOF )
            {
                // Get fields from recordset
                HRESULT hr;
                _variant_t vVar0;
                _variant_t vVar1;
                _variant_t vVar2;
                _variant_t vVar3;
                _variant_t vVar4;
                _variant_t vVar5;
                _variant_t vVar6;
                _variant_t vVar7;

                CString strBuffer;

                // Named method (this works if using sql server and you know the field name)
                //_variant_t vField;
                //vField.vt = VT_BSTR;
                //vField.bstrVal = SysAllocString(L"NAME_NM");
                //hr = ADORecSetPtr->get_Collect( vField, &vVar1 );

                // Positional method
                hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar0 );
                if( vVar0.vt != VT_NULL )
                {
                    if( vVar0.vt == VT_BSTR )
                    {
                        strBuffer = vVar0.bstrVal;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)1), &vVar1 );
                if( vVar1.vt != VT_NULL )
                {
                    if( vVar1.vt == VT_BSTR )
                    {
                        strBuffer += vVar1.bstrVal;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)2), &vVar2 );
                if( vVar2.vt != VT_NULL )
                {
                    if( vVar2.vt != VT_EMPTY )
                    {
                        int iTmp = vVar2.intVal;
                        char cTmp[10];
                        itoa( iTmp, cTmp, 10 );
                        strBuffer += cTmp;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)3), &vVar3 );
                if( vVar3.vt != VT_NULL )
                {
                    if( vVar3.vt != VT_EMPTY )
                    {
                        int iTmp = vVar3.intVal;
                        char cTmp[10];
                        itoa( iTmp, cTmp, 10 );
                        strBuffer += cTmp;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)4), &vVar4 );
                if( vVar4.vt != VT_NULL )
                {
                    if( vVar4.vt != VT_EMPTY )
                    {
                        COleDateTime dt = vVar4.date;
                        CString strTmp = dt.Format("%H:%M");
                        strBuffer += strTmp;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)5), &vVar5 );
                if( vVar5.vt != VT_NULL )
                {
                    if( vVar5.vt != VT_EMPTY )
                    {
                        COleDateTime dt = vVar5.date;
                        CString strTmp = dt.Format("%H:%M");
                        strBuffer += strTmp;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)6), &vVar6 );
                if( vVar6.vt != VT_NULL )
                {
                    if( vVar6.vt == VT_BSTR )
                    {
                        strBuffer += vVar6.bstrVal;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)7), &vVar7 );
                if( vVar7.vt != VT_NULL )
                {
                    if( vVar7.vt == VT_BSTR )
                    {
                        strBuffer += vVar7.bstrVal;
                    }
                }

                //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_ADDSTRING, NULL, (LPARAM)((char*)bstrBuffer) );
                m_ListBox.AddString( strBuffer );

                // Move pointer to next
                ADORecSetPtr->MoveNext();
                bEOF = ADORecSetPtr->adoEOF;
            }
            m_ListBox.SetCurSel(0); // Highlight the col headers
        }
    }
	catch( _com_error &e )
    {
		DumpError(e);
	}
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::GetStudentOptions()
{
    // Set the Query
    m_iQuery = 0;

    // Set cursor to be astheticly pleasing
    HCURSOR hWaitCursor = LoadCursor( NULL, IDC_WAIT );
    HCURSOR hPrevCursor = SetCursor( hWaitCursor );

    try
    {
        SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
	    
	    // The following is not necessary, but can make debugging easier
	    //HRESULT hr = p.CreateInstance( __uuidof(SIMPROFILELib::Profile) );
	    
        // Use the SimProfile COM object
        _RecordsetPtr ADORecSetPtr;
        HRESULT hr = p->GetStudentOptions( (SIMPROFILELib::_Recordset**)&ADORecSetPtr, m_bstrParameter );

        if( SUCCEEDED(hr) )
        {
            short bEOF = NULL;

            if (!ADORecSetPtr->adoEOF)
            {
                ADORecSetPtr->MoveFirst();
            }

            //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_RESETCONTENT, NULL, NULL );
            m_ListBox.ResetContent();
            m_ListBox.AddString( "SYL_ID ^ SYL_EVNT_NAME ^ SYL_EVNT_INDEX ^ RSRC_TYPE" );
        
            while( !bEOF )
            {
                // Get fields from recordset
                HRESULT hr;
                _variant_t vVar0;
                _variant_t vVar1;
                _variant_t vVar2;
                _variant_t vVar3;
                CString strBuffer;

                // Named method (this works if using sql server and you know the field name)
                //_variant_t vField;
                //vField.vt = VT_BSTR;
                //vField.bstrVal = SysAllocString(L"NAME_NM");
                //hr = ADORecSetPtr->get_Collect( vField, &vVar1 );

                // Positional method
                hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar0 );
                if( vVar0.vt != VT_NULL )
                {
                    if( vVar0.vt != VT_EMPTY )
                    {
                        int iTmp = vVar0.intVal;
                        char cTmp[10];
                        itoa( iTmp, cTmp, 10 );
                        strBuffer += cTmp;
                        strBuffer += "^";
                    }
                }
            
                hr = ADORecSetPtr->get_Collect( variant_t((long)1), &vVar1 );
                if( vVar1.vt != VT_NULL )
                {
                    if( vVar1.vt == VT_BSTR )
                    {
                        strBuffer += vVar1.bstrVal;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)2), &vVar2 );
                if( vVar2.vt != VT_NULL )
                {
                    if( vVar2.vt != VT_EMPTY )
                    {
                        int iTmp = vVar2.intVal;
                        char cTmp[10];
                        itoa( iTmp, cTmp, 10 );
                        strBuffer += cTmp;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)3), &vVar3 );
                if( vVar3.vt != VT_NULL )
                {
                    if( vVar3.vt == VT_BSTR )
                        strBuffer += vVar3.bstrVal;
                }

                //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_ADDSTRING, NULL, (LPARAM)((char*)strBuffer) );
                m_ListBox.AddString( strBuffer );

                // Move pointer to next
                ADORecSetPtr->MoveNext();
                bEOF = ADORecSetPtr->adoEOF;
            }
            m_ListBox.SetCurSel(0); // Highlight the col headers
        }
    }
	catch( _com_error &e )
    {
		DumpError(e);
	}
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::GetProdSyl()
{
    // Set the Query
    m_iQuery = GETPRODSYL;

    // Set cursor to be astheticly pleasing
    HCURSOR hWaitCursor = LoadCursor( NULL, IDC_WAIT );
    HCURSOR hPrevCursor = SetCursor( hWaitCursor );

    try
    {
        SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
	    
	    // The following is not necessary, but can make debugging easier
	    //HRESULT hr = p.CreateInstance( __uuidof(SIMPROFILELib::Profile) );
	    
        // Use the SimProfile COM object
        _RecordsetPtr ADORecSetPtr;
        HRESULT hr = p->GetProdSyl( (SIMPROFILELib::_Recordset**)&ADORecSetPtr );

        if( SUCCEEDED(hr) )
        {
            short bEOF = NULL;

            if (!ADORecSetPtr->adoEOF)
            {
                ADORecSetPtr->MoveFirst();
            }

            //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_RESETCONTENT, NULL, NULL );
            m_ListBox.ResetContent();
            m_ListBox.AddString( "NAME ^ VERSION ^ SYLID" );
        
            while( !bEOF )
            {
                // Get fields from recordset
                HRESULT hr;
                _variant_t vVar0;
                _variant_t vVar1;
                _variant_t vVar2;
                CString strBuffer;

                // Named method (this works if using sql server and you know the field name)
                //_variant_t vField;
                //vField.vt = VT_BSTR;
                //vField.bstrVal = SysAllocString(L"NAME_NM");
                //hr = ADORecSetPtr->get_Collect( vField, &vVar1 );

                // Positional method
                hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar0 );

                if( vVar0.vt != VT_NULL )
                {
                    if( vVar0.vt == VT_BSTR )
                    {
                        strBuffer = vVar0.bstrVal;
                        strBuffer += "^";
                    }
                }
            
                hr = ADORecSetPtr->get_Collect( variant_t((long)1), &vVar1 );
                if( vVar1.vt != VT_NULL )
                {
                    if( vVar1.vt == VT_BSTR )
                    {
                        strBuffer += vVar1.bstrVal;
                        strBuffer += "^";
                    }
                }

                hr = ADORecSetPtr->get_Collect( variant_t((long)2), &vVar2 );
                if( vVar2.vt != VT_NULL )
                {
                    if( vVar2.vt != VT_EMPTY )
                    {
                        int iTmp = vVar2.intVal;
                        char cTmp[10];
                        itoa( iTmp, cTmp, 10 );
                        strBuffer += cTmp;
                    }
                }

                //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_ADDSTRING, NULL, (LPARAM)((char*)bstrBuffer) );
                m_ListBox.AddString( strBuffer );

                // Move pointer to next
                ADORecSetPtr->MoveNext();
                bEOF = ADORecSetPtr->adoEOF;
            }
            m_ListBox.SetCurSel(0); // Highlight the col headers

        }
    }
	catch( _com_error &e )
    {
		DumpError(e);
	}
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::GetDeviceEvents()
{
    // Set the Query
    m_iQuery = 0;

    // Set cursor to be astheticly pleasing
    HCURSOR hWaitCursor = LoadCursor( NULL, IDC_WAIT );
    HCURSOR hPrevCursor = SetCursor( hWaitCursor );

    try
    {
        SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
	    
	    // The following is not necessary, but can make debugging easier
	    //HRESULT hr = p.CreateInstance( __uuidof(SIMPROFILELib::Profile) );
	    
        // Use the SimProfile COM object
        _RecordsetPtr ADORecSetPtr;
        HRESULT hr = p->GetDeviceEvents( (SIMPROFILELib::_Recordset**)&ADORecSetPtr, m_bstrParameter );

        if( SUCCEEDED(hr) )
        {
            short bEOF = NULL;

            if (!ADORecSetPtr->adoEOF)
            {
                ADORecSetPtr->MoveFirst();
            }

            //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_RESETCONTENT, NULL, NULL );
            m_ListBox.ResetContent();
            m_ListBox.AddString( "SYLEVENT ^ SORTIEFILE" );
        
            while( !bEOF )
            {
                // Get fields from recordset
                HRESULT hr;
                _variant_t vVar0;
                _variant_t vVar1;
                CString strBuffer;

                // Named method (this works if using sql server and you know the field name)
                //_variant_t vField;
                //vField.vt = VT_BSTR;
                //vField.bstrVal = SysAllocString(L"NAME_NM");
                //hr = ADORecSetPtr->get_Collect( vField, &vVar1 );

                // Positional method
                hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar0 );

                if( vVar0.vt != VT_NULL )
                {
                    if( vVar0.vt == VT_BSTR )
                    {
                        strBuffer = vVar0.bstrVal;
                        strBuffer += "^";
                    }
                }
            
                hr = ADORecSetPtr->get_Collect( variant_t((long)1), &vVar1 );
                if( vVar1.vt != VT_NULL )
                {
                    if( vVar1.vt == VT_BSTR )
                    {
                        strBuffer += vVar1.bstrVal;
                    }
                }

                //::SendMessage( ::GetDlgItem(::GetActiveWindow(), IDC_LIST1), LB_ADDSTRING, NULL, (LPARAM)((char*)bstrBuffer) );
                m_ListBox.AddString( strBuffer );

                // Move pointer to next
                ADORecSetPtr->MoveNext();
                bEOF = ADORecSetPtr->adoEOF;
            }
            m_ListBox.SetCurSel(0); // Highlight the col headers

        }
    }
	catch( _com_error &e )
    {
		DumpError(e);
	}
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::DumpError(_com_error &e)
{
    CString str;
	_bstr_t bstrSource( e.Source() );
	_bstr_t bstrDescription( e.Description() );

    m_iQuery = 0;


    switch( e.Error() )
    {
    case 0x800a0bcd:
		MessageBox( "No records found", _T("Error") );
        break;
    
    case 0x80040e14: // Connection failed or error in sql
		MessageBox( "Database connection failed", _T("Error") );
        break;

    default:
	    str.Format( "\tCode = %08lx", e.Error() );
	    str += " ErrMsg: ";	str += e.ErrorMessage();
	    str += " Source: "; str += bstrSource;
	    str += " Description: "; str += bstrDescription;
    	AfxMessageBox( str );
        break;
    }
}


/////////////////////////////////////////////////////////////////////////////
void CMFCClientDlg::OnButton4() 
{
    // Set the Query
    m_iQuery = GETINSTRUCTOR;

    // Set cursor to be astheticly pleasing
    HCURSOR hWaitCursor = LoadCursor( NULL, IDC_WAIT );
    HCURSOR hPrevCursor = SetCursor( hWaitCursor );

    try
    {
        SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
	    
	    long bInstructor;
        HRESULT hr = p->IsInstructor(&bInstructor);

        if( SUCCEEDED(hr) )
        {
			char lpszUserName[50];
			DWORD lpd = sizeof( lpszUserName );
			GetUserName( lpszUserName, &lpd );

			CString strMsg;
			strMsg.Format("Logged in user (%s) is ", lpszUserName);

			if( !bInstructor )
            {
                strMsg += "NOT ";
            }

			strMsg += "an instructor.";

			AfxMessageBox(strMsg);

        }
    }
	catch( _com_error &e )
    {
		DumpError(e);
	}
}
